; ###############################
; # MICRO-STRATEGY 7 SP2 KEYGEN #
; ##############[XOR37H/ZENiTH]##
;
; serial format is: nnnnnnnnn-xxxx                  
;

.386
.MODEL FLAT,STDCALL
locals
jumps

UNICODE=0                       ; Not Unicode

include res.inc                 ; Resource Includes
include w32.inc                 ; Win 32 Definitions

ICON_SMALL      equ 0

; KERNEL32.dll
        extrn   lstrcatA:proc
        extrn   GetTickCount:proc
        extrn   DrawIcon:proc

.data

        unk_1000C110            db      005h,040h,014h,004h,041h,000h,010h,008h
                                db      004h,045h,010h,00Dh,001h,050h,001h,004h
                                db      040h,004h,041h,004h,055h,041h,055h,009h
                                db      045h,041h,010h,00Ch,041h,050h,041h,00Dh
                                db      050h,041h,010h,001h,051h,045h,051h,001h
                                db      045h,004h,055h,000h,051h,054h,001h,005h
                                db      051h,000h,041h,005h

        unk_1000C144            db      054h,014h,051h,00Ch,011h,015h,000h,00Ch
                                db      045h,050h,040h,005h,045h,050h,050h,000h
                                db      011h,011h,015h,00Dh,011h,044h,050h,001h
                                db      055h,054h,004h,008h,041h,050h,014h,005h
                                db      005h,044h,010h,000h,041h,000h,041h,005h
                                db      051h,010h,045h,00Ch,040h,040h,044h,001h
                                db      044h,045h,054h,001h,015h,010h,001h,009h
                                db      014h,005h,044h,008h,045h,011h,010h,001h
                                db      011h,044h,054h,001h,050h,041h,044h,000h
                                db      045h,014h,055h,009h,011h,040h,004h,00Dh

        unk_1000C194            db      002h,000h,000h,000h,008h,000h,000h,000h
                                db      020h,000h,000h,000h,080h,000h,000h,000h
                                db      000h,002h,000h,000h,000h,008h,000h,000h
                                db      000h,020h,000h,000h,000h,080h,000h,000h
                                db      000h,000h,002h,000h,000h,000h,008h,000h
                                db      000h,000h,020h,000h,000h,000h,080h,000h
                                db      000h,000h,000h,002h

        unk_1000C1C8            db      001h,000h,000h,000h,002h,000h,000h,000h
                                db      004h,000h,000h,000h,008h,000h,000h,000h
                                db      010h,000h,000h,000h,020h,000h,000h,000h
                                db      040h,000h,000h,000h,080h,000h,000h,000h
                                db      000h,001h,000h,000h,000h,002h,000h,000h
                                db      000h,004h,000h,000h,000h,008h,000h,000h
                                db      000h,010h,000h,000h,000h,020h,000h,000h
                                db      000h,040h,000h,000h,000h,080h,000h,000h
                                db      000h,000h,001h,000h,000h,000h,002h,000h
                                db      000h,000h,004h,000h,000h,000h,008h,000h

        unk_1000C218            db      004h,000h,000h,000h,008h,000h,000h,000h
                                db      020h,000h,000h,000h,080h,000h,000h,000h
                                db      000h,002h,000h,000h,000h,008h,000h,000h
                                db      000h,020h,000h,000h,000h,080h,000h,000h
                                db      000h,000h,002h,000h,000h,000h,008h,000h
                                db      000h,000h,020h,000h,000h,000h,080h,000h
                                db      000h,000h,000h,002h

        unk_1000C29C            db      005h,007h,001h,000h,003h,004h,009h,008h
                                db      006h,002h,000h,000h

        unk_1000C24C            db      010h,000h,000h,000h,040h,000h,000h,000h
                                db      000h,001h,000h,000h,000h,004h,000h,000h
                                db      000h,010h,000h,000h,000h,040h,000h,000h
                                db      000h,000h,001h,000h,000h,000h,004h,000h
                                db      000h,000h,010h,000h,000h,000h,040h,000h
                                db      000h,000h,000h,001h,000h,000h,000h,004h
                                db      000h,000h,000h,010h,000h,000h,000h,000h
                                db      000h,000h,000h,000h,000h,000h,000h,000h
                                db      000h,000h,000h,000h,000h,000h,000h,000h
                                db      000h,000h,000h,000h,000h,000h,000h,000h

        random_number_seed      dd       0DEADBEEFh                ; 32-bit random number seed
        serial_end              equ     byte ptr $-01h
        serial_dash             equ     byte ptr $+09h
        serial_halfway_through  equ     byte ptr $+0ah
        serial_start            equ     byte ptr $+0dh

        serial                  db      '000000000-0000',00h     ; Serial to start bruteforcing from...

        done                    dd      0                          ; To tell it to exit the app

        _hInst                  dd      ?                          ; the hInst
        _hWnd                   dd      ?                          ; Window Handle
        _hIcon                  dd      ?
        _msg                    MSG     <?>                        ; The message Structure
        _pnt                    PAINTSTRUCT <?>
        DlgRect                 RECT     <>                     
        DlgWidth                dd      ?
        DlgHeight               dd      ?
        DesktopRect             RECT    <>
                                        
                                 
.code
code_begin:

        call    GetModuleHandle, NULL           ; Get the handle to our app
        mov     _hinst, eax                     ; Store it
        xor     eax, eax                        ; clear eax
        mov     ax, IDD_DIALOG1                 ; load the handle of the dialog into eax
        push    0                               ; Initialization Value...we don't need it, make it 0
        push    offset DlgProc                  ; Pointer to the Procedure which handles messages for the dialog
        push    0                               ; We have no owner window, so this can be null
        push    eax                             ; The dialog that we want to load
        push    _hinst                          ; The hInst
        call    DialogBoxParamA                 ; Create the Dialog

        call    ExitProcess                     ; Exit the Program



; ############### SUBROUTINE #######################################
PUBLIC DlgProc
  DlgProc proc STDCALL, __hwnd:DWORD, wmsg:DWORD, _wparam:DWORD, _lparam:DWORD
  USES  ebx, edi, esi

        xor     eax,eax                         ; Clear eax
        mov     ax, word ptr [wmsg]             ; Put the message into eax
 .IF ax==WM_DESTROY                             ; Was the msg WM_DESTROY
         jmp  _wmdestroy                        ; If so, destroy the window
 .ELSEIF ax==WM_CLOSE                           ; Same thing if it's WM_CLOSE
         jmp  _wmdestroy
 .ELSEIF ax==WM_COMMAND                         ; WM_COMMAND means something interesting happened
         jmp    _wmcommand                      ; So process it
 .ELSEIF ax==WM_INITDIALOG                      ; Code runs when the dialog is first initialized
         jmp    _initdlg
 .ENDIF                                 
        xor     eax,eax
        ret                                     ; Exit the message loop, return 0
_wmdestroy:
        push    0                               ; Return 0
        push    __hWnd                          ; The handle of the Dialog
        call    EndDialog                       ; End the Dialog
        call    ExitProcess                     ; Exit Process
        mov     done, 1                         ; This wasn't working even before i added the ExitProcess call ;)
        ret
_wmcommand:
        cmp     _wparam, IDOK                   ; Did they press the OK button?
        jne     @teo
        call    GenKey, __hWnd                  ; If they did, generate their key
@teo:
        ret
_initdlg:                                       ; Here we will put the icon on the dialog and center the dialog
        push    IDI_ICON                        ; The Icon Identifier, from the resource file (included in res.inc)
        push    _hinst                          ; The hInstance
        call    LoadIcon                        ; Load the Icon
        
        mov     _hIcon, eax                     ; Store the Icon handle
        push    eax                             ; Push it for the call to load the icon into the titlebar
        push    ICON_SMALL                      ; The icon to be used in the title bar is the small icon
        push    WM_SETICON                      ; The message to send
        push    __hwnd                          ; The window handle
        call    SendMessage                     ; Send the Message
        
        ; Code to center the dialog

        push    OFFSET DlgRect                  ; Ptr to the Rect struct that will store the coordinates
        push    __hwnd                          ; The window handle
        call    GetWindowRect
        call    GetDesktopWindow                ; get the handle to the Desktop window
        push    OFFSET DesktopRect              ; offset to the Rect struct that holds the size ofthe desktop
        push    eax                             ; The hWnd ofthe desktop
        call    GetWindowRect                   ; Get the info
        push    0                               ; Part of the later call to MoveWindow (no repaint)
        mov     eax,DlgRect.rc_bottom           ; Get the bottom of our dialogs window
        sub     eax,DlgRect.rc_top              ; subtract the y value at the top of our window
        mov     DlgHeight,eax                   ; And store it as the dialog's height
        push    eax                             ; Push it for the call to MoveWindow
        mov     eax,DlgRect.rc_right            ; The X coordinate of the right side of our dialog
        sub     eax,DlgRect.rc_left             ; minus that of the left side
        mov     DlgWidth,eax                    ; gives us the width
        push    eax                             ; Push it for the call to MoveWindow
        mov     eax,DesktopRect.rc_bottom       ; Get the bottom of the desktop window
        sub     eax,DlgHeight                   ; Subtract the height of our dialog
        shr     eax,1                           ; and divide by 2...this gives the middle of the screen
        push    eax                             ; Push for the movewindow call
        mov     eax,DesktopRect.rc_right        ; Get the right side of the desktop
        sub     eax,DlgWidth                    ; Minus the width of our dialog
        shr     eax,1                           ; Divide by 2
        push    eax                             ; Push it
        push    __hwnd                          ; Push the window handle
        call    MoveWindow                      ; Move the window
        ret
        
DlgProc ENDP



; ############### SUBROUTINE #######################################
GenKey proc _hDlg:dword
uses eax, ecx, edx, edi

generate:
	push	09h
	pop	ecx
	
        lea     edi,serial
gen_first_half:
        push    0ah                     	; Get random number within ten
        pop     eax                     	;  "    "      "      "     "
        call    get_random_number_within_range

        xchg    eax,edx
        add     al,'0'
        stosb
        
	loop	gen_first_half		

	push	04h
	pop	ecx

	inc	edi
gen_second_half:
        push    24h                     	; Get random number within thirty-seven
        pop     eax                     	;  "    "      "      "         "
        call    get_random_number_within_range

        xchg    eax,edx
        add     al,'0'
	cmp	al,'9'
	jbe	store_byte_of_serial
	
	add	al,'A'-'9'-01h
store_byte_of_serial:
        stosb
        
	loop	gen_second_half		
next_serial:
        lea     edi,serial_start
generate_serial:
        inc     byte ptr [edi]
        cmp     byte ptr [edi],'9'
        jbe     CheckSerial

        cmp     edi,offset serial_halfway_through
        jb      beyond_halfway
        
        cmp     byte ptr [edi],'Z'
        ja      beyond_halfway
        
        mov     al,'A'
        cmp     [edi],al
        ja      CheckSerial
        
        mov     [edi],al

        jmp     CheckSerial
beyond_halfway:
        mov     byte ptr [edi],'0'
found_dash:
        dec     edi

        cmp     edi,offset serial_dash
        je      found_dash
        cmp     edi,offset serial_end
        jne     generate_serial
_ExitProcess:
        push    00h                     ; Exit code for all threads
        call    ExitProcess
CheckSerial:
        push offset serial
        call fnSerialkey

        cmp     eax,0FFFFFFFBh          ; dont know correct return
        je      next_serial             ; so we check against known, error returns
        cmp     eax,0FFFFFFFCh
        je      next_serial
        cmp     eax,0FFFFFFFDh
        je      next_serial
        cmp     eax,0FFFFFFFEh
        je      next_serial
        cmp     eax,0FFFFFFFFh
        je      next_serial
        
        push    offset serial                   ; Pointer to the serial
        push    IDC_EDIT1                       ; The edit box to put the info into
        push    _hDlg                           ; The dialog handle
        call    SetDlgItemText                  ; Set the text
        ret                                     ; return

GenKey endp

; ############### SUBROUTINE #######################################
; Random Number Generator (RNG) at 22 bytes
get_random_number       proc            ; Get 32-bit random number
        push    eax ebx
        call    GetTickCount
        lea     ebx,random_number_seed  	; EBX = pointer to random_number_seed
        mul     dword ptr [ebx]         	; Multiply previous miliseconds with
                                        	; current miliseconds
        sbb     edx,eax                 	; Add low-order word of 32-bit random
                                        	; number to high-order word of 32-bit
                                        	; random number
        cmc                             	; Complement carry flag
        adc     [ebx],edx               	; Store 32-bit random number
        pop     ebx eax

        ret

endp



; ############### SUBROUTINE #######################################
get_random_number_within_range  proc    	; Get random number within range
        push    ebx
        call    get_random_number

        xchg    eax,ebx                 	; EBX = number in range
        xor     eax,eax                 	; Zero EAX
        xchg    eax,edx                 	; EAX = 32-bit random number
        div     ebx                     	; EDX = random number within range
        pop     ebx

        ret

endp

; ############### SUBROUTINE #######################################
fnSerialkey      proc near

  arg_0          =      dword   ptr  4  ; serial number in asciiZ

         mov     eax, [esp+arg_0]
         push    eax
         call    sub_10003820
         add     esp, 4
         retn    4
         
fnSerialkey      endp



; ############### SUBROUTINE #######################################
sub_10003820     proc near

  var_10         =      dword   ptr -10h
  var_C          =      byte    ptr -0Ch
  var_3          =      byte    ptr -3
  arg_0          =      dword   ptr  4

         sub     esp, 10h
         push    ebx
         push    ebp
         mov     ebp, [esp+18h+arg_0]
         push    esi
         test    ebp, ebp
         push    edi
         jnz     short loc_1000383C
         pop     edi
         pop     esi
         pop     ebp
         mov     eax, 0FFFFFFFBh
         pop     ebx
         add     esp, 10h
         retn
loc_1000383C:
         mov     edi, ebp
         or      ecx, 0FFFFFFFFh
         xor     eax, eax
         repne scasb
         not     ecx
         dec     ecx
         cmp     ecx, 9                         ; must be 9 chars long
         jz      short loc_10003870
         cmp     ecx, 0Eh                       ; or be 14 chars long
         jz      short loc_1000385D
         pop     edi
         pop     esi
         pop     ebp
         or      eax, 0FFFFFFFFh
         pop     ebx
         add     esp, 10h
         retn
loc_1000385D:
         cmp     byte ptr [ebp+9], 2Dh          ; dash '-'
         jz      short loc_10003870
         pop     edi
         pop     esi
         pop     ebp
         mov     eax, 0FFFFFFFEh
         pop     ebx
         add     esp, 10h
         retn
loc_10003870:
         mov     edx, ebp
         lea     esi, [esp+20h+var_C]
         sub     edx, esi
         mov     [esp+20h+var_3], 0
         lea     eax, [esp+20h+var_C]
         mov     esi, 9
loc_10003886:
         mov     bl, [edx+eax]
         sub     bl, 30h                        ; '0'
         mov     [eax], bl
         inc     eax
         dec     esi
         jnz     short loc_10003886
         lea     eax, [ebp+0Ah]
         lea     esi, [esp+20h+var_C]
         mov     edi, 9                         ; 9 chars
         mov     eax, [eax]
         mov     [esp+20h+var_10], eax
loc_100038A4:
         xor     edx, edx
         xor     eax, eax
         mov     dl, [esi]
         mov     ebx, 0Ah
         mov     al, byte ptr unk_1000C29C[edx]
         xor     edx, edx
         mov     dl, [esi+1]
         sub     eax, edx
         add     eax, 0Ah
         cdq
         idiv    ebx
         inc     esi
         dec     edi
         mov     [esi-1], dl
         jnz     short loc_100038A4
         xor     ebp, ebp
         cmp     ecx, 0Eh                               ; 14 chars
         jnz     short loc_1000392C
         xor     cl, cl
loc_100038D2:
         movsx   eax, cl
         mov     al, byte ptr [esp+eax+20h+var_10]
         cmp     al, 30h                                ; 30 = '0'
         mov     byte ptr [esp+20h+arg_0], al
         jb      short loc_10003919
         cmp     al, 5Ah                                ; 5A = Z
         ja      short loc_10003919
         cmp     al, 39h                                ; 39 = 9
         jbe     short loc_10003907
         cmp     al, 41h                                ; 41 = A
         jb      short loc_10003919
loc_100038ED:
         mov     eax, [esp+20h+arg_0]
         and     eax, 0FFh
         sub     eax, 37h                               ; 37 = 7
loc_100038F9:
         shl     ebp, 5
         add     ebp, eax
         inc     cl
         cmp     cl, 4                                  ; 4 chars
         jl      short loc_100038D2
         jmp     short loc_10003926
loc_10003907:
         cmp     al, 41h                                ; 41 = A
         jnb     short loc_100038ED
         mov     eax, [esp+20h+arg_0]
         and     eax, 0FFh
         sub     eax, 30h                               ; 30 = 0
         jmp     short loc_100038F9
loc_10003919:
         pop     edi
         pop     esi
         pop     ebp
         mov     eax, 0FFFFFFFDh
         pop     ebx
         add     esp, 10h
         retn
loc_10003926:
         xor     ebp, 0B73BBh
loc_1000392C:
         xor     eax, eax
         lea     ecx, [esp+20h+var_C]
         mov     edx, 9
loc_10003937:
         xor     ebx, ebx
         lea     eax, [eax+eax*4]
         mov     bl, [ecx]
         inc     ecx
         dec     edx
         lea     eax, [ebx+eax*2]
         jnz     short loc_10003937
         mov     esi, eax
         and     eax, 0D555555h
         and     esi, 0F2AAAAAAh
         xor     edx, edx
         xor     ecx, ecx
         mov     edi, 0Dh
loc_1000395B:
         test    dword ptr unk_1000C194[ecx], esi
         jbe     short loc_10003973
         mov     ebx, dword ptr unk_1000C110[ecx]
         xor     eax, ebx
         mov     ebx, dword ptr unk_1000C218[ecx]
         add     edx, ebx
loc_10003973:
         add     ecx, 4
         dec     edi
         jnz     short loc_1000395B
         xor     ecx, ecx
         mov     esi, 0Fh
loc_10003980:
         test    dword ptr unk_1000C1C8[ecx], ebp
         jbe     short loc_10003998
         mov     ebx, dword ptr unk_1000C144[ecx]
         mov     edi, dword ptr unk_1000C24C[ecx]
         xor     eax, ebx
         add     edx, edi
loc_10003998:
         add     ecx, 4
         dec     esi
         jnz     short loc_10003980
         mov     ecx, eax
         xor     ecx, 0C104145h
         jnz     short loc_100039B2
         pop     edi
         pop     esi
         pop     ebp
         mov     eax, edx
         pop     ebx
         add     esp, 10h
         retn
loc_100039B2:
         mov     ecx, eax
         xor     ecx, 0C540515h
         jnz     short loc_100039C7
         pop     edi
         pop     esi
         pop     ebp

         lea     eax, [edx+1]
         pop     ebx
         add     esp, 10h
         retn
loc_100039C7:
         xor     eax, 0C114055h
         lea     eax, [edx+2]
         jz      short loc_100039D6
         mov     eax, 0FFFFFFFCh
loc_100039D6:
         pop     edi
         pop     esi
         pop     ebp
         pop     ebx
         add     esp, 10h
         retn
sub_10003820     endp


end          code_begin

